﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultPerformancePlugin.Controls.Strategy;

namespace WinfootDefaultPerformancePlugin.Controls
{
    public partial class SpoolerPriority : UserControl, ICorrespondenceOS, IControl
    {
        private SpoolerPriorityController spoolerPriorityController;

       public SpoolerPriority()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                    
#if DEBUG
                                           OS.WindowsSeven
#endif
                                       }; 
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.migiside.net/wiki/doku.php?id=plugin:performance:spoolerpriority"));
                userHelp.Show();
            }
        }

        public void SetSpoolerPriorityValue(int i)
        {
            switch (i)
            {
                case 0x20:
                    radioButton1.Checked = true;
                    break;
                case 0x40:
                    radioButton2.Checked = true;
                    break;
                default:
                    radioButton3.Checked = true;
                    break;
            }
        }


        public int GetSpoolerPriorityValue()
        {
            if (radioButton1.Checked)
            {
                return 0x20F;
            }
            if (radioButton2.Checked)
            {
                return 0x40;
            }
            return 0x60;
        }

        #region IControl メンバ

        public void Apply()
        {
            spoolerPriorityController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return spoolerPriorityController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void SpoolerPriority_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            spoolerPriorityController = new SpoolerPriorityController(this,
                                                                                      (ISpoolerPriorityStrategy)
                                                                                      wfUtillity.
                                                                                          GetCorrespondenceInstance
                                                                                          (new List<ICorrespondenceOS>
                                                                                               {
                                                                                                   new SpoolerPriorityDefaultStrategy()
                                                                                               }));
            spoolerPriorityController.Read();
        }
    }
}
